import viz
import vizmat
import math
import time
viz.go(viz.STEREO | viz.TRACKER | viz.FULLSCREEN)
#commands to enable HMD tracking
if viz.get(viz.TRACKER):
	v = viz.add('intersense.dls')
	#pos = viz.add('vizppt.dls')
	viz.tracker()
	v.reset()
	tracking = 1
else:
	tracking = 0
	viz.collision(viz.ON)

viz.translate(viz.HEAD_POS,0,0,-1)

#Set eye distance to 0 to show why the bullet goes to the left of the mouse
#viz.ipd(0)
headPos = viz.get(viz.HEAD_POS) 

#arrays
people = ['male.cfg','female.cfg','GZ_fSol.cfg']
faces = ['morph_head.vzf','biohead_talk.vzf','moira.vzf']
avatars = []				#for avatars
bullets = []				#for number of balls
dead_list = []				#list for dead avatars

#constants
NUM_BULLETS = 3				#number of balls in the array
BULLET_SPEED = 250			#speed in meters/secs of the bullet
rotRight = viz.Transform()	#bullet rotation
rotRight.setRot(0,1,0,-90)
ANIMATION = 1				#animation ID
NUM_AVATARS	= 6				#the number of avatars
TIME_BETWEEN_AVATARS = 3	#time between each avatar
START_AVATAR = 0			#flag to start avatars
nextAvatar = 0 				#index for avatars
nextBullet = 0				#index for the next ball in the array
ACTIVE_AVATARS = 5			#create a flag to reset array
index = NUM_AVATARS			#looping index
nextAvatar = 0
avatarsHit = 0				#keeping track of how many avatars were hit
theta = (math.pi / 3)
HEAD_DEPTH = 0				#Depth for how far the participant is in the scene
keyindex = 0
quitcount = 0				#index for quitting
crosshair = viz.add(viz.TEXQUAD)
crosshair.texture(viz.add('crosshair.tif'))
crosshair.scale(0.01,0.01,0.01)

sunlight = viz.add(viz.LIGHT)
sunlight.position(10,10,-20)
sunlight.direction(-0.5,-0.5,1)
sunlight.color(1,1,1)

sky = viz.add('skydome.dlc',0,'',15)
env = viz.add(viz.ENVIRONMENT_MAP,'sky.bmp')
sky.texture(env)
sky.disable(viz.FOG)

court = viz.add('terrain1.wrl')
court.scale(0.5,0.5,0.5)
court.rotate(0,1,0,-90)
court.translate(-5,0,-10)
court.appearance(viz.MODULATE)
court.disable(viz.LIGHT0)
#Create six avatars
for i in range(len(people)):
	newX = -10 * math.sin(theta * i)
	newZ = 10 * math.tan(theta * i)
	if newZ <=10:
		newZ = -15
	else:
		newZ = 10 * math.tan(theta * i)
	#print i,"\t\t\t\t\t",newX,"\t",newZ
	male = viz.add(people[i])
	if(i==2):
		male.scale(.12,.12,.12)
	#male.scale(1.25,1.25,1.25)
	male.face(faces[i])
	male.translate(newX,-10,newZ)
	#avPos = male.get(viz.POSITION)
	#print 'original avatar position', avPos 
	male.rotate(180,0,0)
	avatars.append(male) #Save avatar in list

def walkAvatar(starter):
	global court, headPos
	walk = starter.walkto(0,court,HEAD_DEPTH,1,260,2)
	#Clear all the avatar's actions, reposition it, and start the walk action
	starter.clear(viz.ALL)
	starter.act(walk)


for x in range(0,NUM_BULLETS):
	#create a bullet that is initially hidden
	bullet = viz.add('ball.wrl')
	bullet.scale(.1,.1,.1)
	bullet.visible(viz.OFF)
	bullet.disable(viz.COLLISION)
	bullet.active = 0
	
	#add the ball to the ball list
	bullets.append(bullet)

def RemoveAvatar(avatar):
	
	avatar.visible(0) #Hide avatar
	avatar._face_.visible(0) #Hide face
	avatar.speed(1) #Restore speed
	avatars.remove(avatar) #Remove from list
	dead_list.append(avatar) #Add to dead list

def RestoreAvatar():
	global keyindex
	#Get random direction
	angle = viz.radians(vizmat.GetRandom(0,360))
	#Get random radius between 10 and 20
	radius = vizmat.GetRandom(10,20)
	x = math.sin(angle) * radius
	#account for both positive and negative depths.  Allows control for avatars to come from front and back.
	if (keyindex % 2) == 0:
		z = math.cos(angle) * radius
	else:
		z = -math.cos(angle) * radius
	if len(dead_list):
		avatar = dead_list.pop() #Ressurrect dead avatar
		avatar.visible(1) #Make it visible
		avatars.append(avatar) #Add it to avatar list
		avatar.face('biohead_talk.vzf')
		avatar.translate(x,0,z)
		print 'Restored avatar position is', avatar.get(viz.POSITION)
		walkAvatar(avatar)
	print 'avatar restored'
def shootBullet():
	global nextBullet
	#find the next available ball to shoot
	bullet = bullets[nextBullet]
	nextBullet = (nextBullet + 1) % NUM_BULLETS
	#Calculate the vector of the ball based on the mouse position
	pos = viz.mousepos()
	bulletvector = viz.screentoworld(pos[0]+0.25,pos[1]) #Need to account for stereo
	bullet.vector = viz.Vector(bulletvector[3]-bulletvector[0],bulletvector[4]-bulletvector[1],bulletvector[5]-bulletvector[2])
	bullet.vector.normalize()
	bullet.vector *= BULLET_SPEED
	
	#translate the bullet to the head position
	bullet.translate(viz.get(viz.HEAD_POS))
	
	#make the bullet visible
	bullet.visible(viz.ON)
	
	#mark the bullet as active
	bullet.active = 1

def MoveBullet(bullet,elapsed):
	global avatarsHit
	#get the bullet's current position
	pos = bullet.get(viz.POSITION)
	
	#calculate the balls future position based on it's velocity
	futurePos = pos + (bullet.vector * elapsed)
	
	#Check if bullet intersected with anything
	info = viz.intersect(pos,futurePos)
	if info.intersected:
		avatarsHit = avatarsHit + 1
		print 'intersect point is',info.intersectPoint
		if info.object in avatars:
			print 'Avatars hit: ', avatarsHit
			WaitThenFreeze = vizact.sequence( vizact.waittime(info.object.getduration(7)-0.005), vizact.speed_node(0) )
			info.object.execute(7)
			info.object.clear(viz.ALL)
			info.object.clear(viz.CURRENT_ACTION)
			info.object.add(WaitThenFreeze) #Add the action to the avatar
			RemoveAvatarAction = vizact.call(RemoveAvatar,info.object)
			info.object.add(RemoveAvatarAction) #Add action to remove avatar

		bullet.visible(0)
		bullet.active = 0
	
	#Update balls positions
	bullet.translate(futurePos.get())
def mytimer(num):
	global avatars, quitcount
	if num == ANIMATION:
		
		#Calculate elapsed time since last update
		elapsed = viz.elapsed()
		
		#Update each active ball
		for bullet in bullets:
			if bullet.active:
				#Move the ball and check if it has collided with any objects
				MoveBullet(bullet,elapsed)


	elif num == START_AVATAR:
		global nextAvatar
		#Get the next available avatar and start it
		avatar = avatars[nextAvatar]
		avatarsLength = len(avatars)
		print 'nextAvatar is', avatarsLength
		walkAvatar(avatar)
		nextAvatar = (nextAvatar + 1) % avatarsLength
		walkAvatar(avatar)
		viz.starttimer(START_AVATAR,TIME_BETWEEN_AVATARS)
	linepos = viz.mousepos()
	#line = viz.screentoworld(viz.mousepos())
	line = viz.screentoworld(linepos[0]+.11,linepos[1])
	v = viz.Vector(viz.get(viz.HEAD_POS))
	dir = viz.Vector(line[3:]) - viz.Vector(line[:3])
	dir.normalize()
	dir *= 0.1 #Place crosshair 1/10th meter in front of user
	v += dir
	crosshair.translate(v.get())
	crosshair.rotatequat(viz.get(viz.VIEW_QUAT))
	if len(dead_list) > 0:
		RestoreAvatar()
		quitcount = quitcount + 1
	if quitcount == 10:
		viz.quit()

#Restore next available avatar
def onkeydown(key):
	global keyindex
	if key == ' ':
		RestoreAvatar()
		keyindex = keyindex + 1
	if key == 'm':
		body = 'male.cfg'
		

viz.callback(viz.KEYDOWN_EVENT,onkeydown)

#Shoot a ball whenever left mousebutton is clicked
vizact.onmousedown(viz.MOUSEBUTTON_LEFT,shootBullet)

#Create callbacks for timer events
viz.callback(viz.TIMER_EVENT,mytimer)

#Start a timer which starts the next available avatar
viz.starttimer(START_AVATAR,0.1)

#Start the animation timer, which animates the bullet and checks for collisions
viz.starttimer(ANIMATION,0.01,-1)

#Move the head position back
viz.translate(viz.HEAD_POS,0,0,HEAD_DEPTH)	

#Disable mouse navigation
viz.mouse(viz.OFF)
#viz.cursor(0)
 

###################################################################################
###################################################################################
#####                     Data Collection                                      ####
###################################################################################
###################################################################################
##Mark the time that the program was started.
#start_time = time.time()
##Open a file to collect the data on this subject.
#question_data = open('study_data','w')
##Get the data from the button press.
#def onkeydown(key):
##Use our starting time variable to find out how much
##time has elapsed.
#	elapsed_time = time.time() - start_time
##Create string lines to put in the data file, depending on which
##button was pushed.
#	if key == 'q':
#		subject_data = 'Subject ' + str(subject) + '\t'
#		condition_data = 'Condition ' + str(choice) + '\n'
#		#Write the data to our file. 
#		question_data.write(subject_data)
#		question_data.write(condition_data)
#		#Flush the internal buffer.
#		question_data.flush() 
#	#Close the world.
#	viz.quit()
#
#viz.callback(viz.KEYDOWN_EVENT,onkeydown) 